// Package notifiarr provides a notification service for Notifiarr API integration.
//
// The Notifiarr service enables sending notifications through the Notifiarr platform,
// which supports multiple notification channels including Discord, Slack, and more.
// It provides a unified interface for sending notifications with optional Discord-specific
// features like channel targeting, thumbnails, images, colors, and mention parsing.
//
// # URL Format
//
// The service URL follows the format:
//
//	notifiarr://API_KEY[?query]
//
// Where:
//   - API_KEY: Your Notifiarr API key
//   - query: Optional configuration parameters
//
// # Configuration Options
//
// The following query parameters can be used to configure the service:
//
//   - channel: Discord channel ID for notifications (optional)
//   - thumbnail: Thumbnail URL for Discord notifications (optional)
//   - image: Image URL for Discord notifications (optional)
//   - color: Color for Discord notifications (optional)
//
// # Event ID for Message Updates
//
// You can specify an event ID to enable message updates:
//
//	params := types.Params{"id": "unique-event-id"}
//	err := shoutrrr.Send(url, "Message content", params)
//
// # Discord Mention Parsing
//
// The service automatically parses Discord user and role mentions from message content.
// Mentions are extracted and included in the Discord payload:
//
//	// Message with mentions
//	message := "Alert for <@123456789> and <@&987654321>"
//	err := shoutrrr.Send(url, message, nil)
//
// # Image/Thumbnail Support
//
// Set thumbnail and image URLs for Discord notifications:
//
//	url := "notifiarr://your-api-key?thumbnail=https://example.com/thumbnail.png&image=https://example.com/image.png"
//	err := shoutrrr.Send(url, "Message with thumbnail and image", nil)
//
// # Advanced Text Fields
//
// The service supports advanced text formatting through parameter fields:
//
//   - icon: Icon URL for the notification embed
//   - content: Additional content text above the main message
//   - footer: Footer text for the notification embed
//
// Example usage:
//
//	params := types.Params{
//		"icon":    "https://example.com/icon.png",
//		"content": "Additional context information",
//		"footer":  "Generated by MyApp v1.0",
//	}
//	err := shoutrrr.Send(url, "Main message content", params)
//
// # Color Customization
//
// Customize the color of Discord notifications:
//
//	url := "notifiarr://your-api-key?color=16711680" // Red color
//	err := shoutrrr.Send(url, "Colored notification", nil)
//
// # URL Parameter Configuration
//
// Configure channel targeting:
//
//	url := "notifiarr://your-api-key?channel=123456789012345678"
//	err := shoutrrr.Send(url, "Channel-specific message", nil)
//
// # Examples
//
// ## Basic notification sending
//
//	url := "notifiarr://your-api-key"
//	err := shoutrrr.Send(url, "Hello from Notifiarr!")
//
// ## Notification with title and event ID
//
//	url := "notifiarr://your-api-key"
//	params := types.Params{
//		"id": "alert-123",
//		"title": "System Alert",
//	}
//	err := shoutrrr.Send(url, "Server is down", params)
//
// ## Discord notification with channel, thumbnail, and image
//
//	url := "notifiarr://your-api-key?channel=123456789012345678&thumbnail=https://example.com/thumbnail.png&image=https://example.com/image.png"
//	err := shoutrrr.Send(url, "Alert message", nil)
//
// ## Notification with mentions and color
//
//	url := "notifiarr://your-api-key?color=65280" // Green color
//	message := "Task completed <@123456789>"
//	err := shoutrrr.Send(url, message, nil)
//
// # Common Use Cases
//
// ## Monitoring System Integration
//
// Send alerts from monitoring systems:
//
//	url := "notifiarr://your-api-key?channel=monitoring-channel-id"
//	err := shoutrrr.Send(url, "High CPU usage detected", types.Params{"title": "System Monitor"})
//
// ## Application Notifications
//
// Send notifications from applications:
//
//	url := "notifiarr://your-api-key"
//	err := shoutrrr.Send(url, "Deployment completed successfully", types.Params{
//		"id": "deploy-2024-01-01",
//		"title": "Deployment Status",
//	})
//
// ## Discord Bot Integration
//
// Send formatted Discord messages:
//
//	url := "notifiarr://your-api-key?channel=discord-channel-id&color=16776960&thumbnail=https://example.com/thumbnail.png&image=https://example.com/image.png"
//	message := "New user registered: <@newuser123>"
//	err := shoutrrr.Send(url, message, types.Params{
//		"title":   "User Registration",
//		"icon":    "https://example.com/icon.png",
//		"content": "Welcome to our platform!",
//		"footer":  "User management system",
//	})
//
// # Error Handling
//
// The service returns errors for network failures, invalid API keys, and API errors.
// Always check the returned error:
//
//	err := shoutrrr.Send(url, message)
//	if err != nil {
//	    log.Printf("Failed to send notification: %v", err)
//	}
//
// # Security Considerations
//
// - Store API keys securely, not in URLs in production
// - Validate API keys before deployment
// - Use HTTPS for all communications
// - Consider rate limiting for high-volume notifications
package notifiarr
