;;; Copyright (C) 2023, 2025 Igalia, S.L.
;;;
;;; Licensed under the Apache License, Version 2.0 (the "License");
;;; you may not use this file except in compliance with the License.
;;; You may obtain a copy of the License at
;;;
;;;    http://www.apache.org/licenses/LICENSE-2.0
;;;
;;; Unless required by applicable law or agreed to in writing, software
;;; distributed under the License is distributed on an "AS IS" BASIS,
;;; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;;; See the License for the specific language governing permissions and
;;; limitations under the License.

;;; Commentary:
;;;
;;; Promise tests.
;;;
;;; Code:

(use-modules (srfi srfi-64)
             (test utils))

(test-begin "test-promises")

(with-additional-imports ((scheme lazy))
  (test-call "#t" (lambda () (promise? (delay 42))))
  (test-call "#t" (lambda () (promise? (delay-force (make-promise 42)))))
  (test-call "42" (lambda () (force (delay 42))))
  (test-call "42" (lambda () (force (delay-force (delay 42))))))

(test-end* "test-promises")
