#define XERR "memorybuf"
#include "memorybuf.ih"

    // by memorystream/memorystream3.cc

MemoryBuf::MemoryBuf(int id, bool erase, std::ios::openmode openMode)
:
    d_mode(openMode),
    d_bridge(id, erase)
{
    if
    (
        openMode & ios::trunc               // rm the bytes from the memory's 
        ||                                  // segments, and resize to the
        (openMode & ios::out and not (openMode & ios::in))  // original size
    )
    {
        size_t size = d_bridge.writtenUntil();
        d_bridge.truncate(0);
        d_bridge.truncate(size);
    }

    noBuffers();
}
